/*------------------------------------------------------------------------------*
 * File Name: XFWizNavigation.h													*
 * Creation: Sim 03-20-2007														*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS			*
 *	Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
 *------------------------------------------------------------------------------*/

#ifndef __XF_WIZ_NAVG_H__
#define __XF_WIZ_NAVG_H__

#include <..\OriginLab\XFCore.h>
#include <..\OriginLab\XFWiz.h>

class XFWizNavigation
{
public:
	XFWizNavigation(XFCore *pXFCore);
	~XFWizNavigation();
public:
	bool			InitWizard(XFWizRunModelBase *pXFWizRM, XFWizTheme* pXFWizTheme = NULL, XFWizInputOutputRange* pXFWizIO = NULL);

	bool			OnBegin();
	bool			OnFinish();
	bool			OnCancel();
	bool			OnNext();
	bool			OnPrev();
	
	bool			OnChangeStep(int nStep);
	
	///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	//bool			IsFinish();
	///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	
	enum
	{
		SUCCESS_UPDATE_STEPS,
		FAILED_UPDATE_STEPS,
		FAILED_CURRENT_STEP_OUT_OF_TARGET_RANGE_OF_XFNAME,
		FAILED_PASTED_STEPS_ARE_NOT_CONSISTENT,
		FAILED_UPDATE_STEP_LABELS,
	};
	int			SetSteps(const StringArray& saXFNames);
	int			GetNumSteps();
	int			GetStep();
	string		GetXFName(int nStep);

	bool		UpdateThemeSetting(bool bToTheme = true);
	
	XFCore*		GetXFCore();
	XFWizInputOutputRange*		GetXFWizInputOutputRange();
	
	///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	//void SetDefaultSteps(const StringArray& saDefaultXFNames);
	///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	//void SetMapStepLabels(const StringArray& saMapXFNames, const StringArray& saMapXFLabels);
	
	void		SetMapStepLabels(const StringArray& saMapXFNames, const StringArray& saMapXFLabels);
	bool		GetStepLabels(const const StringArray& saXFNames, StringArray& saXFLables);
protected:
	bool		GoToStep(int nStep);
	
	bool		LoadXF(LPCSTR lpcszXFName);
	bool		ApplyCurXF();
	bool		UndoCurXF();
	
	bool		UpdateGetN(bool bToGetN);
	
	//bool		SetThemeClassOption(TreeNode& trGetN, LPCSTR lpcszClassOption);
	//bool		SaveLastUsedTheme();
	
	bool		LoadSteps();
	
	
	//bool		GetStepLabels(const StringArray& saXFNames, StringArray& saXFLables);
	
	
	bool		AfterLoadXF();
	
	bool		GoFinish();
	bool		GoCancel();
	bool		GoNext();
	bool		GoPrev();
	//int			ChangeStep(int nStepTo, int nStepFrom);
	int			ChangeStep(int nStep);
	
	//bool		SetActiveStep(int nStep);
	
protected:
	int			m_nStep;
	StringArray	m_saXFNames;

	XFCore			*m_pXFCore;
	XFWizTheme		*m_pXFWizTheme;
	XFWizInputOutputRange	*m_pXFWizIO;
	XFWizRunModelBase		*m_pXFWizRM;
	
	///---Sim 01-14-2009 FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	//StringArray m_saDefaultXFNames;
	///---END FIX_XFWIZ_COMPARE_DEFAULT_THEME_MISS_DEFAULT_STEPS
	StringArray m_saMapXFNames;
	StringArray m_saMapXFLabels;
	
	///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	//bool		m_bFinish;
	///---END FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
};



//#include <..\OriginLab\XFWizNavigation.h>
//#include <Control.h>
//
//#define WM_USER_WIZ_DLG_OFFSET (WM_USER + 1201)
//enum
//{
	//WM_USER_WIZ_DLG_GET_STEPS_CTRL = WM_USER_WIZ_DLG_OFFSET,
	//WM_USER_WIZ_DLG_AFTER_LOAD_XF,
	//WM_USER_WIZ_DLG_APPLY_XF,
	//WM_USER_WIZ_DLG_UNDO_XF,
	//WM_USER_WIZ_DLG_FINISH,
	//WM_USER_WIZ_DLG_PAGE_EVENT_LINK,
//};
//
//class XFWizDlgNavigation : public XFWizNavigation
//{
//public:
	//XFWizDlgNavigation(XFCore *pXFCore);
	//~XFWizDlgNavigation();
//public:
	//void		InitWizard(HWND hParent, XFWizTheme* pXFWizTheme = NULL, XFWizInputOutputRange* pXFWizIO = NULL);
	//void		UpdateWizardControl();
	//
	////virtual int			SetSteps(const StringArray& saXFNames);
	//
	////bool			OnBegin();
	////bool			OnFinish();
	////bool			OnCancel();
	////bool			OnNext();
	////bool			OnPrev();
	//// When Active step is changed, programmatically  or graphically
	////BOOL		OnWizardStepActivate(int nIndexActivate, int nIndexDeactivate);
	//
	////bool		OnSaveTheme(LPCSTR lpcszThemeName);
	////bool		OnLoadTheme(LPCSTR lpcszThemeName);
	//
	////XFWizControl*	GetXFWizControl();
	//
	////void		OnDestroy();
	//bool		IsFinish();
//
	//bool		UpdateThemeSetting(bToTheme = true);
	//
////protected:
	//////DWORD		SendDlgMsg(DWORD msg, DWORD wParam = 0, DWORD lParam = 0);
	////
	//////WizardControl*	GetXFWizControl();
	////
	////virtual bool	GoToStep(int nStep);
	////
	//////virtual bool	OnAfterSetSteps();
	//////virtual bool	OnAfterChangeStep();
	////
	////virtual	bool	OnAfterLoadXF();
	//////virtual	bool	OnBeforeApplyXF();
	////
	////bool		GoCancel();
	////bool		GoNext();
	////bool		GoPrev();
	////int			ChangeStep(int nStepTo, int nStepFrom);
	////
	////bool		SetActiveStep(int nStep);
	////
	//////virtual bool		ApplyCurXF();
	////virtual bool		UndoCurXF();
//protected:
	////XFWizControl	*m_pXFWizCtrl;
	////HWND		m_hParent;
//
	//bool		m_bFinish;
	//
	////StringArray m_saLables;
//};

#endif		//__XF_WIZ_NAVG_H__
